TITLE   'Steel Bar Heated by Moving Torch' 			{ exa193.pde }
SELECT     							
   errlim=1e-3     ngrid=1     spectral_colors
VARIABLES   temp( threshold=0.1)
DEFINITIONS
   Lx=1.0     Ly=0.2     d0=0.1     vx= 1e-3 		{ Torch velocity }
   heat=0     tempi=300     k=82     rcp=7.87e3*449 	{ Steel }
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxdm=magnitude( fluxd)	
   fluxd0=-1e6*[ ustep( vx*t+d0- x)- ustep( vx*t- x) ]
INITIAL VALUES
   temp=tempi
EQUATIONS
   div( fluxd)+ rcp*dt( temp)=heat
BOUNDARIES
region 'domain'
   start (0,0)  value(temp)=tempi  line to (Lx,0)
   natural(temp)=0 line to (Lx,Ly)
   natural(temp)=fluxd0  line to (0,Ly)
   natural(temp)=0 line to close
TIME   from 0 to 800
PLOTS
   for t=50 by 50 to 800
   elevation( temp) from (0,Ly) to (Lx,Ly)
   contour( temp) painted     vector( fluxd) norm
END


